// npm package: chart.js
// github link: https://github.com/chartjs/Chart.js

$(function () {
    'use strict';


    var colors = {
        primary: "#6571ff",
        secondary: "#7987a1",
        success: "#05a34a",
        info: "#66d1d1",
        warning: "#fbbc06",
        danger: "#ff3366",
        light: "#e9ecef",
        dark: "#060c17",
        muted: "#7987a1",
        gridBorder: "rgba(77, 138, 240, .15)",
        bodyColor: "#000",
        gray:"#4D8AF026",
        cardBg: "#fff",
        green: "#00ff00",
        red: "#ff0000"
    }

    var fontFamily = "'iransans', Helvetica, sans-serif"


    // Doughnut Chart
    if ($('#day').length) {
        let Usage = parseInt($('#day').attr("data-usage"))
        let Free = parseInt($('#day').attr("data-free"))
        let t = $('#day').attr("data-text")
        console.log(t)
        new Chart($('#day'), {
            type: 'doughnut',
            data: {

                datasets: [{
                    label: "day",
                    backgroundColor: [colors.red, colors.green],
                    borderColor: colors.cardBg,
                    data: [Usage, Free],
                    weight: 10,

                }]
            },
            options: {
                aspectRatio: 2,
                plugins: {
                    tooltip: {
                        rtl: true
                    },
                    legend: {
                        rtl: true,
                        display: true,
                        labels: {
                            color: colors.light,
                            font: {
                                size: '16px',
                                family: fontFamily
                            }
                        }
                    },
                }
            }
        });
    }

    //ram
    if ($('#volume').length) {
        let Usage = parseInt($('#volume').attr("data-usage"))
        let Free = parseInt($('#volume').attr("data-free"))
        let t = $('#volume').attr("data-text")
        console.log(t)
        new Chart($('#volume'), {
            type: 'doughnut',
            data: {

                datasets: [{
                    label: "volume",
                    backgroundColor: [colors.red, colors.green],
                    borderColor: colors.cardBg,
                    data: [Usage, Free],
                    weight: 10,

                }]
            },
            options: {
                aspectRatio: 2,
                plugins: {
                    tooltip: {
                        rtl: true
                    },
                    legend: {
                        rtl: true,
                        display: true,
                        labels: {
                            color: colors.light,
                            font: {
                                size: '16px',
                                family: fontFamily
                            }
                        }
                    },
                }
            }
        });
    }






});